
varying vec3 normal, lightDir, eyeVec;
	uniform sampler2D Texture0,Texture1;

void main (void)
{
	vec4 final_color = texture2D(Texture0,gl_TexCoord[0].st).rgba;
final_color.rgb   *= texture2D(Texture1,gl_TexCoord[1].st).rgb;

							
	vec3 N = normal;
	vec3 L = lightDir;
	
	float lambertTerm = dot(N,L);

	if(lambertTerm > 0.0)
	{
	
		
		vec3 E = eyeVec;
		vec3 R = reflect(-L, N);
		float specular = pow( max(dot(R, E), 0.0), 1.0 );
		final_color.rgb *= 1.3-(specular)*0.7;	
	}

	gl_FragColor = final_color;			
}